function w = passeggiata_unod_chemotaxisdiffusion_obstacle(v, c, U, theta, chi, cmax, w_max)
% Movimento stocastico con chemotassi e ostacolo all'infiltrazione
% v     = T-cell attuali
% c     = chemoattrattante
% U     = densita'  tumorale (ostacolo)
% theta = probabilita'  massima di diffusione
% chi   = coefficiente di chemotassi
% cmax  = scala normalizzante per chemotassi
% w_max = soglia oltre la quale si blocca il movimento

n = length(v);
w = zeros(n,1);

% Calcolo della mobilita'  locale
densita = U;
mobilita = max(0, 1 - densita / w_max);

% Movimento interno (escludendo i bordi)
theta_eff = theta * mobilita(2:end-1);
chi_eff = chi * mobilita(2:end-1);

prob_s = theta_eff / 2 + chi_eff .* subplus(c(1:end-2) - c(2:end-1)) / (2 * cmax);
prob_d = theta_eff / 2 + chi_eff .* subplus(c(3:end) - c(2:end-1)) / (2 * cmax);
prob_c = 1 - prob_s - prob_d;

% Multinomial sampling per celle interne
b = mnrnd(v(2:end-1), [prob_s, prob_c, prob_d]);

% Ricomposizione del nuovo vettore
w = [b(:,1); 0; 0] + [0; b(:,2); 0] + [0; 0; b(:,3)];

% BORDO SINISTRO
theta_edge = theta * mobilita(1);
chi_edge = chi * mobilita(1);
p_dx = theta_edge / 2 + chi_edge * subplus(c(2) - c(1)) / (2 * cmax);
p_cx = 1 - p_dx;

a = mnrnd(v(1), [p_cx, p_dx]);
w(1) = a(1);
w(2) = w(2) + a(2);

% BORDO DESTRO
theta_edge = theta * mobilita(end);
chi_edge = chi * mobilita(end);
p_sx = theta_edge / 2 + chi_edge * subplus(c(end-1) - c(end)) / (2 * cmax);
p_dx = 1 - p_sx;

a = mnrnd(v(end), [p_sx, p_dx]);
w(end-1) = w(end-1) + a(1);
w(end) = a(2);
